*                                                                                  ;
 *    Reading in the 1981 PSID data                                                 ;
 *                                                                                  ;
 *            Karen Dynan 8/26/06                                                   ;
 *                                                                                  ;
 *    We read it all in and then output select variables to a flat                  ;
 *    file to be picked up by STATA.                                                ;
 *                                                                                  ;
 
libname psid 'F:\PSID' ;
filename rawdat 'F:\PSID\raw\fam81.raw' ;
 
 data one;
 
   infile 'F:\PSID\81FAM.DAT'  lrecl=1241 missover;
   INPUT
   V7501 1-3              V7502 4-7              V7503 8-9
   V7504 10-12            V7505 13-17            V7506 18
   V7507 19               V7508 20               V7509 21
   V7510 22               V7511 23               V7512 24
   V7513 25               V7514 26               V7515 27
   V7516 28               V7517 29-34            V7518 35
   V7519 36-40            V7520 41               V7521 42-45
   V7522 46               V7523 47-50            V7524 51
   V7525 52-55            V7526 56               V7527 57-60
   V7528 61               V7529 62-65            V7530 66-69
   V7531 70               V7532 71-74            V7533 75
   V7534 76-79            V7535 80               V7536 81-84
   V7537 85               V7538 86-89            V7539 90
   V7540 91-94            V7541 95               V7542 96-99
   V7543 100              V7544 101-104          V7545 105
   V7546 106-109          V7547 110              V7548 111-114
   V7549 115              V7550 116              V7551 117-118
   V7552 119              V7553 120-124 .2       V7554 125-129
   V7555 130-133          V7556 134              V7557 135-138
   V7558 139              V7559 140-143          V7560 144
   V7561 145              V7562 146-148          V7563 149
   V7564 150-153          V7565 154              V7566 155-158
   V7567 159              V7568 160-163          V7569 164
   V7570 165-166          V7571 167-171          V7572 172-176
   V7573 177-181          V7574 182              V7575 183-187
   V7576 188-192          V7577 193-196          V7578 197-200
   V7579 201              V7580 202-206          V7581 207
   V7582 208-213          V7583 214-219          V7584 220-224
   V7585 225-229          V7586 230-234          V7587 235-238
   V7588 239-243          V7589 244              V7590 245-251
   V7591 252-256          V7592 257              V7593 258-259
   V7594 260              V7595 261-265          V7596 266
   V7597 267-270          V7598 271-275          V7599 276-280
   V7600 281-285          V7601 286-290          V7602 291-294
   V7603 295-299          V7604 300-303          V7605 304-307
   V7606 308-312          V7607 313              V7608 314-318
   V7609 319-323          V7610 324-325          V7611 326
   V7612 327-331          V7613 332-333          V7614 334
   V7615 335-339          V7616 340-341          V7617 342
   V7618 343-347          V7619 348-349          V7620 350
   V7621 351-355          V7622 356-357          V7623 358
   V7624 359-362          V7625 363-367          V7626 368
   V7627 369              V7628 370-374          V7629 375-379
   V7630 380-384          V7631 385-389          V7632 390-394
   V7633 395-399          V7634 400-403          V7635 404-408
   V7636 409-412          V7637 413-416          V7638 417-421
   V7639 422              V7640 423              V7641 424
   V7642 425-428          V7643 429-432          V7644 433-436
   V7645 437-440          V7646 441-444          V7647 445-448
   V7648 449-452          V7649 453-456          V7650 457-460
   V7651 461-464          V7652 465-468          V7653 469-472
   V7654 473-476          V7655 477-480          V7656 481-483
   V7657 484-485          V7658 486-487          V7659 488
   V7660 489-490          V7661 491-492          V7662 493-494
   V7663 495              V7664 496              V7665 497
   V7666 498              V7667 499              V7668 500
   V7669 501              V7670 502-506          V7671 507
   V7672 508              V7673 509              V7674 510
   V7675 511              V7676 512              V7677 513-514
   V7678 515              V7679 516              V7680 517
   V7681 518              V7682 519-522          V7683 523
   V7684 524              V7685 525              V7686 526
   V7687 527-530          V7688 531              V7689 532
   V7690 533-536          V7691 537              V7692 538
   V7693 539-542          V7694 543              V7695 544
   V7696 545-548          V7697 549              V7698 550
   V7699 551-554          V7700 555              V7701 556-557
   V7702 558              V7703 559              V7704 560
   V7705 561              V7706 562              V7707 563
   V7708 564              V7709 565              V7710 566
   V7711 567-569          V7712 570-572          V7713 573-575
   V7714 576              V7715 577-580          V7716 581
   V7717 582-585          V7718 586-589          V7719 590-593
   V7720 594              V7721 595-598          V7722 599-601
   V7723 602              V7724 603              V7725 604
   V7726 605-606          V7727 607              V7728 608
   V7729 609              V7730 610              V7731 611
   V7732 612-613          V7733 614              V7734 615-616
   V7735 617              V7736 618-619          V7737 620
   V7738 621-622          V7739 623              V7740 624-625
   V7741 626-627          V7742 628-629          V7743 630
   V7744 631              V7745 632-633          V7746 634
   V7747 635-638          V7748 639-640          V7749 641-642
   V7750 643-646          V7751 647-649          V7752 650
   V7753 651              V7754 652              V7755 653
   V7756 654              V7757 655-658          V7758 659-661
   V7759 662              V7760 663              V7761 664
   V7762 665              V7763 666              V7764 667-670
   V7765 671-673          V7766 674              V7767 675
   V7768 676              V7769 677              V7770 678
   V7771 679              V7772 680-681          V7773 682
   V7774 683-684          V7775 685-686          V7776 687
   V7777 688-689          V7778 690-691          V7779 692
   V7780 693              V7781 694              V7782 695
   V7783 696-699          V7784 700              V7785 701
   V7786 702              V7787 703              V7788 704
   V7789 705-707          V7790 708              V7791 709-710
   V7792 711              V7793 712              V7794 713
   V7795 714              V7796 715-716          V7797 717
   V7798 718-719          V7799 720-721          V7800 722-725
   V7801 726              V7802 727              V7803 728
   V7804 729-732          V7805 733-734          V7806 735
   V7807 736-738          V7808 739-741          V7809 742
   V7810 743-744          V7811 745              V7812 746-747
   V7813 748              V7814 749-750          V7815 751
   V7816 752-753          V7817 754              V7818 755-756
   V7819 757              V7820 758-759          V7821 760-761
   V7822 762-763          V7823 764-767          V7824 768-770
   V7825 771              V7826 772              V7827 773
   V7828 774              V7829 775              V7830 776-779
   V7831 780-782          V7832 783              V7833 784
   V7834 785              V7835 786              V7836 787
   V7837 788-791          V7838 792-794          V7839 795
   V7840 796              V7841 797              V7842 798
   V7843 799              V7844 800              V7845 801-802
   V7846 803              V7847 804-805          V7848 806-807
   V7849 808              V7850 809-810          V7851 811-812
   V7852 813              V7853 814              V7854 815
   V7855 816-818          V7856 819              V7857 820-821
   V7858 822              V7859 823              V7860 824-825
   V7861 826              V7862 827-828          V7863 829
   V7864 830-831          V7865 832              V7866 833-835
   V7867 836-838          V7868 839-840          V7869 841-842
   V7870 843              V7871 844              V7872 845
   V7873 846-847          V7874 848              V7875 849
   V7876 850              V7877 851              V7878 852
   V7879 853              V7880 854              V7881 855
   V7882 856              V7883 857              V7884 858-860
   V7885 861-863          V7886 864-866          V7887 867
   V7888 868-871          V7889 872-875          V7890 876
   V7891 877-879          V7892 880-881          V7893 882
   V7894 883              V7895 884-885          V7896 886
   V7897 887-888          V7898 889              V7899 890-891
   V7900 892              V7901 893-894          V7902 895
   V7903 896-897          V7904 898-899          V7905 900-901
   V7906 902              V7907 903              V7908 904-905
   V7909 906-907          V7910 908-909          V7911 910-912
   V7912 913              V7913 914-915          V7914 916
   V7915 917-918          V7916 919              V7917 920
   V7918 921-922          V7919 923              V7920 924-926
   V7921 927-929          V7922 930              V7923 931-932
   V7924 933              V7925 934-935          V7926 936
   V7927 937-938          V7928 939              V7929 940-941
   V7930 942              V7931 943-944          V7932 945
   V7933 946-947          V7934 948-949          V7935 950-951
   V7936 952-954          V7937 955              V7938 956-957
   V7939 958              V7940 959              V7941 960-961
   V7942 962              V7943 963-965          V7944 966-968
   V7945 969-970          V7946 971-972          V7947 973
   V7948 974              V7949 975              V7950 976
   V7951 977              V7952 978              V7953 979
   V7954 980              V7955 981              V7956 982-983
   V7957 984-985          V7958 986              V7959 987
   V7960 988              V7961 989              V7962 990
   V7963 991              V7964 992              V7965 993
   V7966 994              V7967 995              V7968 996
   V7969 997              V7970 998              V7971 999
   V7972 1000             V7973 1001             V7974 1002
   V7975 1003             V7976 1004             V7977 1005-1007
   V7978 1008             V7979 1009             V7980 1010-1012
   V7981 1013             V7982 1014             V7983 1015
   V7984 1016             V7985 1017-1019        V7986 1020
   V7987 1021             V7988 1022-1024        V7989 1025
   V7990 1026             V7991 1027             V7992 1028
   V7993 1029             V7994 1030             V7995 1031
   V7996 1032             V7997 1033             V7998 1034-1035
   V7999 1036             V8000 1037             V8001 1038
   V8002 1039             V8003 1040             V8004 1041
   V8005 1042-1043        V8006 1044-1045        V8007 1046-1047
   V8008 1048             V8009 1049             V8010 1050-1051
   V8011 1052-1054        V8012 1055-1056        V8013 1057-1059
   V8014 1060             V8015 1061             V8016 1062
   V8017 1063-1064        V8018 1065-1066        V8019 1067-1068
   V8020 1069-1070        V8021 1071             V8022 1072
   V8023 1073             V8024 1074             V8025 1075-1076
   V8026 1077-1079        V8027 1080             V8028 1081
   V8029 1082             V8030 1083             V8031 1084
   V8032 1085             V8033 1086             V8034 1087
   V8035 1088-1089        V8036 1090-1091        V8037 1092-1093
   V8038 1094             V8039 1095-1096        V8040 1097
   V8041 1098             V8042 1099             V8043 1100
   V8044 1101             V8045 1102             V8046 1103
   V8047 1104             V8048 1105             V8049 1106
   V8050 1107             V8051 1108-1109        V8052 1110-1114
   V8053 1115-1116        V8054 1117-1120        V8055 1121-1122
   V8056 1123-1126        V8057 1127-1128        V8058 1129-1132
   V8059 1133-1134        V8060 1135-1138        V8061 1139-1140
   V8062 1141-1144        V8063 1145-1146        V8064 1147-1151
   V8065 1152-1158        V8066 1159-1163        V8067 1164-1167 .2
   V8068 1168-1171        V8069 1172-1175 .2     V8070 1176-1179 .2
   V8071 1180             V8072 1181             V8073 1182
   V8074 1183             V8075 1184             V8076 1185
   V8077 1186-1187        V8078 1188-1189        V8079 1190-1194
   V8080 1195             V8081 1196-1197 .1     V8082 1198-1199
   V8083 1200             V8084 1201             V8085 1202
   V8086 1203             V8087 1204             V8088 1205
   V8089 1206             V8090 1207             V8091 1208
   V8092 1209             V8093 1210             V8094 1211
   V8095 1212             V8096 1213             V8097 1214
   V8098 1215             V8099 1216             V8100 1217
   V8101 1218-1220        V8102 1221             V8103 1222-1223
   V8104 1224             V8105 1225-1228        V8106 1229-1230
   V8107 1231             V8108 1232             V8109 1233-1236
   V8110 1237-1240        V8111 1241;

* SAS LABEL STATEMENT;

LABEL
   V7501 = "STUDY NUMBER (701)"
   V7502 = "1981 INTERVIEW NUMBER"
   V7503 = "CURRENT STATE"
   V7504 = "CURRENT COUNTY"
   V7505 = "CURRENT STATE+CNTY"
   V7506 = "SIZE LGST CITY/SMSA-1981"
   V7507 = "COLOR COVERSHEET-1981"
   V7508 = "WHETHER REFUSED-1981"
   V7509 = "TELEPHONE INT?-1981"
   V7510 = "FAM COMP CHANGE-1981"
   V7511 = "#MOVED IN-1981"
   V7512 = "WHO MOVED IN-1981"
   V7513 = "# MOVED OUT-1981"
   V7514 = "WHO MOVED OUT-1981"
   V7515 = "CURRENT FAM COMP-1981"
   V7516 = "QUALITY OF MATCH-1981"
   V7517 = "1981 HOUSE VALUE (B7)"
   V7518 = "ACC 1981 HOUSE VALUE"
   V7519 = "REM MTGE PRIN 81 (B9)"
   V7520 = "ACC REM MTGE PRIN 1981"
   V7521 = "ANN MTGE PYTS 81 (B10)"
   V7522 = "ACC ANN MTGE PYTS-1981"
   V7523 = "ANN PROPERTY TAX 81 (B13"
   V7524 = "ACC ANN PROPERTY TX-1981"
   V7525 = "ANN RENT-1981 (B14)"
   V7526 = "ACC ANN RENT-1981"
   V7527 = "ANN VALUE IF RENTED/B17"
   V7528 = "ACC ANN VALUE IF RENTED"
   V7529 = "GOVT SUBSIDY-HTG COST/B5"
   V7530 = "HD ANN WRK HRS IN 1980"
   V7531 = "ACC HD 80 WORK HRS"
   V7532 = "HD HRS WRK LOST OTR ILL"
   V7533 = "ACC HD HR LOST OTR ILL"
   V7534 = "HD HRS WRK LOST OWN ILL"
   V7535 = "ACC HD HRS LOST OWN ILL"
   V7536 = "HD STRIKE HOURS 1980"
   V7537 = "ACC HD STRIKE HRS 1980"
   V7538 = "HD UNEMP HRS 1980"
   V7539 = "ACC HD UNEMP HRS 1980"
   V7540 = "WF ANN WRK HRS IN 1980"
   V7541 = "ACC WF 80 WRK HRS"
   V7542 = "WF HRS WRK LOST OTR ILL"
   V7543 = "ACC WF HR LOST OTR ILL"
   V7544 = "WF HRS WRK LOST OWN ILL"
   V7545 = "ACC WF HRS LOST OWN ILL"
   V7546 = "WF STRIKE HOURS 1980"
   V7547 = "ACC WF STRIKE HRS 1980"
   V7548 = "WF UNEMP HRS 1980"
   V7549 = "ACC WF UNEMP HRS 1980"
   V7550 = "# MAJOR ADULTS"
   V7551 = "1981 FAMILY SIZE"
   V7552 = "# REQUIRED ROOMS"
   V7553 = "1981 WEEKLY FOOD NEEDS"
   V7554 = "1981 ANNUAL NEED STD"
   V7555 = "WF ANN HSEWRK HRS (J5)"
   V7556 = "ACC WF ANN HSEWRK HRS"
   V7557 = "HD ANN HSEWRK HRS (J6)"
   V7558 = "ACC HD ANN HSEWRK HRS"
   V7559 = "OTR ANN HSEWRK HRS (J10)"
   V7560 = "ACC OTR ANN HSWRK HRS"
   V7561 = "# PERSONS GOT FOOD STAMP"
   V7562 = "$ $  VALU FD ST LST MO-J14"
   V7563 = "ACC $ $  VALU FD ST LST MO"
   V7564 = "ANN FD $ $  EXC FD STMP"
   V7565 = "ACC ANN FOOD $ $"
   V7566 = "ANN $ $  EATING OUT"
   V7567 = "ACC ANN $ $  EATING OUT"
   V7568 = "$ $  VALUE FOOD STMPS 1980"
   V7569 = "ACC $ $  VALU FD ST 1980"
   V7570 = "# MOS USED FD ST 1980"
   V7571 = "LABOR PART FARM Y 1980"
   V7572 = "LABOR PART BUS Y 1980"
   V7573 = "HEAD 1980 WAGES"
   V7574 = "ACC HEAD 1980 WAGES"
   V7575 = "HD BONUS/OT/COMM 1980"
   V7576 = "HD PROF PRAC/TRADE 1980"
   V7577 = "LABOR PT MKT GRDNG 1980"
   V7578 = "LABOR PT ROOMERS 1980"
   V7579 = "ACC HD LABOR Y EX WAGES"
   V7580 = "WIFE 1980 LABOR/WAGE"
   V7581 = "ACC WF 80 LABOR/WAGE"
   V7582 = "ASSET PART FARM Y 1980"
   V7583 = "ASSET PART BUS Y 1980"
   V7584 = "ASSET PT MKT GRDNG 1980"
   V7585 = "ASSET PT ROOMERS 1980"
   V7586 = "HD RENT/INT/DIVDNDS 1980"
   V7587 = "ALIMONY Y HEAD 1980"
   V7588 = "WF 1980 OTHER ASSET Y"
   V7589 = "ACC H+W 1980 ASSET Y"
   V7590 = "H+W 1980 TAXABLE Y"
   V7591 = "H+W 1980 SUPP OTR NONFU"
   V7592 = "H+W 1980 # DEPENDENTS"
   V7593 = "H+W TOTAL 1980 EXEMPTION"
   V7594 = "1980 TAX TABLE USED-H+W"
   V7595 = "H+W 1980 ADC/AFDC"
   V7596 = "ACC H+W 1980 ADC/AFDC"
   V7597 = "H+W 1980 SSI"
   V7598 = "H+W 1980 OTR WELFARE"
   V7599 = "H+W 1980 SOCIAL SECURITY"
   V7600 = "HD OTHER RETIREMENT 1980"
   V7601 = "HD 1980 UNEMPLMT COMP"
   V7602 = "HD 1980 WORKMANS COMP"
   V7603 = "HD 1980 CHILD SUPPORT"
   V7604 = "HD 1980 HELP FROM RELS"
   V7605 = "HD 1980 OTHER TRANSFER Y"
   V7606 = "WF 1980 OTHER TRANSFER Y"
   V7607 = "ACC H+W 1980 TRAN YNOADC"
   V7608 = "H+W 1980 TOT TRANSFER Y"
   V7609 = "TXBL Y 1ST XTRA EARNER"
   V7610 = "# EXEMP 1ST XTRA EARNER"
   V7611 = "TAX TABLE 1ST XTRA EARNR"
   V7612 = "TXBL Y 2ND XTRA EARNER"
   V7613 = "# EXEMP 2ND XTRA EARNER"
   V7614 = "TAX TABLE 2ND XTRA EARNR"
   V7615 = "TXBL Y 3RD XTRA EARNER"
   V7616 = "# EXEMP 3RD XTRA EARNER"
   V7617 = "TAX TABLE 3RD XTRA EARNR"
   V7618 = "TXBL Y 4TH XTRA EARNER"
   V7619 = "# EXEMP 4TH XTRA EARNER"
   V7620 = "TAX TABLE 4TH XTRA EARNR"
   V7621 = "TXBL Y 5TH XTRA EARNER"
   V7622 = "# EXEMP 5TH XTRA EARNER"
   V7623 = "TAX TABLE 5TH XTRA EARNR"
   V7624 = "OTRS 1980 ANN WRK HRS"
   V7625 = "OTR 1980 TOT ANN TXBL Y"
   V7626 = "ACC OTR ANN TXBL Y-1980"
   V7627 = "BKT OTR 1980 ASSET Y"
   V7628 = "OTR 1980 ADC/AFDC"
   V7629 = "OTR 1980 SSI"
   V7630 = "OTR 1980 OTHR WELFARE"
   V7631 = "OTR 1980 SOCIAL SECURITY"
   V7632 = "OTR 1980 OTR RETIREMENT"
   V7633 = "OTR 1980 UNEMPL COMP"
   V7634 = "OTR 1980 WORKERS COMP"
   V7635 = "OTR 1980 CHILD SUPPORT"
   V7636 = "OTR 1980 HELP FR RELS"
   V7637 = "OTR 1980 MISC TRANSFERS"
   V7638 = "OTR 1980 TOT TRANSFER Y"
   V7639 = "ACC OTR 1980 TRANSFERS"
   V7640 = "# OTR Y RECEIVERS-1980"
   V7641 = "# OTR LABOR Y RECRS-1980"
   V7642 = "1968 ID"
   V7643 = "1969 ID"
   V7644 = "1970 ID"
   V7645 = "1971 ID"
   V7646 = "1972 ID"
   V7647 = "1973 ID"
   V7648 = "1974 ID"
   V7649 = "1975 ID"
   V7650 = "1976 ID"
   V7651 = "1977 ID"
   V7652 = "1978 ID"
   V7653 = "1979 ID"
   V7654 = "1980 ID"
   V7655 = "DATE OF 1981 INT"
   V7656 = "LENGTH OF 1981 INT"
   V7657 = "# IN FU"
   V7658 = "AGE OF 1981 HEAD"
   V7659 = "SEX OF 1981 HEAD"
   V7660 = "AGE OF 1981 WIFE"
   V7661 = "# CHILDREN IN FU"
   V7662 = "AGE YOUNGEST CHILD"
   V7663 = "A2 PUB TRANS NEARBY?"
   V7664 = "A3 WTR PUB TRANS GD ENUF"
   V7665 = "A4 DU INSIDE CITY LIMITS"
   V7666 = "A5 DIST TO CNTR CITY"
   V7667 = "A6 DIST CNTR NRST CITY"
   V7668 = "A7 WTR OWN CAR/TRUCK"
   V7669 = "A8 #CARS/TRUCKS OWNED"
   V7670 = "A9 # MI DRIVEN-ALL CARS"
   V7671 = "B1 ACTUAL # ROOMS"
   V7672 = "B2 TYPE DWELLING"
   V7673 = "B3 TYPE FUEL FOR HEAT"
   V7674 = "B4 RECD GOVT HTNG SUBSDY"
   V7675 = "B5 OWN/RENT OR WHAT"
   V7676 = "B8 WTR MORTGAGE"
   V7677 = "B11 # YRS REMAIN ON MTGE"
   V7678 = "B12 WTR 2ND MORTGAGE"
   V7679 = "B15 WTR HU RENTED FURNIS"
   V7680 = "B16 WHY NOT OWN/RENT"
   V7681 = "B18 WTR PAY ELECTRICITY"
   V7682 = "TOT ELECT BILL-1980"
   V7683 = "ACC TOT ELECT BILL 1980"
   V7684 = "B21 WHY NOT PAY ELECT"
   V7685 = "B22 WTR PAY NAT/BOT GAS"
   V7686 = "B23 WTR BOTTLED GAS"
   V7687 = "TOT GAS BILL-1980"
   V7688 = "ACC TOT GAS BILL-1980"
   V7689 = "B26 WTR PAY HTNG OIL"
   V7690 = "TOT OIL BILL-1980"
   V7691 = "ACC TOT OIL BILL-1980"
   V7692 = "B29 WTR PAY COAL/WOOD"
   V7693 = "TOT COAL/WOOD BILL-1980"
   V7694 = "ACC COAL/WOOD BILL-1980"
   V7695 = "B31 WTR PAY H2O/SEWAGE"
   V7696 = "TOT H2O/SEWAGE BILL-1980"
   V7697 = "ACC TOT H2O BILL-1980"
   V7698 = "B33 WHY NOT PAY H2O/SEWG"
   V7699 = "TOT ANN UTILITIES-1980"
   V7700 = "B34 MOVD SINCE SPR 1980?"
   V7701 = "B35 MONTH MOVED"
   V7702 = "B36 WHY MOVED"
   V7703 = "B37 WTR MIGHT MOVE"
   V7704 = "B38 LIKELIHOOD OF MOVING"
   V7705 = "B39 WHY MIGHT MOVE"
   V7706 = "C1 EMPLMT STATUS-HEAD"
   V7707 = "C2 WORK SELF/OTR?(HD-E)"
   V7708 = "C3 WORK FOR GOVT?(HD-E)"
   V7709 = "C4 IS JOB NOW UNION(H-E)"
   V7710 = "C5 BELONG UNION? (HD-E)"
   V7711 = "C6 # MOS THIS EMP(HD-E)"
   V7712 = "C7-8 MAIN OCC:3DIG(H-E)"
   V7713 = "C9 MAIN IND:3 DIGT(H-E)"
   V7714 = "C10 SLRY/HRLY/OTR (H-E)"
   V7715 = "C11 PAY/HR-SALARY(HD-E)"
   V7716 = "C12 WTR SAL PD OT(HD-E)"
   V7717 = "C13 PAY/HR-SLRYOT(HD-E)"
   V7718 = "C14 PAY/HR-HOURLY(HD-E)"
   V7719 = "C15 PAY/HR-HRLY OT(H-E)"
   V7720 = "C16 HOW PAID     (HD-E)"
   V7721 = "C17 PAY/HR-OTR OT (H-E)"
   V7722 = "C18 # MOS THIS JOB(H-E)"
   V7723 = "C20 TASKS CHG 1 YR(H-E)"
   V7724 = "C21 UP/DN GRD JOB(HD-E)"
   V7725 = "C21 # NEW TASKS  (HD-E)"
   V7726 = "C22 MO START JOB (HD-E)"
   V7727 = "C23 HPND PREV JOB(HD-E)"
   V7728 = "C24 JOB BETTER?  (HD-E)"
   V7729 = "C25 WHY BET/WORSE(HD-E)"
   V7730 = "C26 JOB PAY MORE?(HD-E)"
   V7731 = "C27 WTR OTRS ILL (HD-E)"
   V7732 = "C28 # WKS OTR ILL(HD-E)"
   V7733 = "C29 WTR SELF ILL (HD-E)"
   V7734 = "C30 # WKS SELF ILL(HD-E)"
   V7735 = "C31 WTR VACATION (HD-E)"
   V7736 = "C32 # WK VACATION(HD-E)"
   V7737 = "C33 WTR STRIKE   (HD-E)"
   V7738 = "C34 # WK ON STRIKE(H-E)"
   V7739 = "C35 WTR UNEMPLOYD(HD-E)"
   V7740 = "C36 # WK UNEMPLYD(HD-E)"
   V7741 = "C37 # WKS WORKED (HD-E)"
   V7742 = "C39 # HR/WK WRKD (HD-E)"
   V7743 = "C40 WTR WRK OT   (HD-E)"
   V7744 = "C42 WTR XTRA JOBS(HD-E)"
   V7745 = "C43 OCC-XTRA JOBS (HD-E)"
   V7746 = "C43-C44 # XTRA JOB(H-E)"
   V7747 = "C45 PAY/HR XTRA JB(H-E)"
   V7748 = "C46 # WKS XTRA JOB(H-E)"
   V7749 = "C47 HR/WK XTRA JOB(H-E)"
   V7750 = "C49 MO-YR LST UNEM(H-E)"
   V7751 = "C50 #WK UNEMP-LST(HD-E)"
   V7752 = "C51 WTR 4+ WK-LST(HD-E)"
   V7753 = "C52 WTR 4+ WK-LST(HD-E)"
   V7754 = "C53 4+ WK >ONCE?1(HD-E)"
   V7755 = "C54 # X NO LOOK-1(HD-E)"
   V7756 = "C56 WTR 2ND UNEMP(HD-E)"
   V7757 = "C57 MO-YR 2ND UNEM(H-E)"
   V7758 = "C58 #WK UNEMP-2ND(HD-E)"
   V7759 = "C59 WTR 4+ WK-2ND(HD-E)"
   V7760 = "C60 WTR 4+ WK-2ND(HD-E)"
   V7761 = "C61 4+ WK >ONCE?2(HD-E)"
   V7762 = "C62 # X NO LOOK-2(HD-E)"
   V7763 = "C63 WTR 3RD UNEMP(HD-E)"
   V7764 = "C64 MO-YR 3RD UNEM(H-E)"
   V7765 = "C65 #WK UNEMP-3RD(HD-E)"
   V7766 = "C66 WTR 4+ WK-3RD(HD-E)"
   V7767 = "C67 WTR 4+ WK-3RD(HD-E)"
   V7768 = "C68 4+ WK >ONCE?3(HD-E)"
   V7769 = "C69 # X NO LOOK-3(HD-E)"
   V7770 = "C70 WTR REC UNEMP(HD-E)"
   V7771 = "C71 WTR USED UP $ $ (HD-E)"
   V7772 = "C72 #WK NO UNEMP$ $ (HD-E)"
   V7773 = "C73 WTR ELIG UNEM(HD-E)"
   V7774 = "C74 WHY NO UNEMP-1(H-E)"
   V7775 = "C74 WHY NO UNEMP-2(H-E)"
   V7776 = "C75 OTR Y/UNEMP? (HD-E)"
   V7777 = "C76 TYPE OTR Y-1 (HD-E)"
   V7778 = "C76 TYPE OTR Y-2 (HD-E)"
   V7779 = "C77 RET SAME EMPLR(H-E)"
   V7780 = "C78 RET SAME JOB?(HD-E)"
   V7781 = "C79 MORE $ $  LATER?(HD-E)"
   V7782 = "C80 MRE WRK AVAILB(H-E)"
   V7783 = "C81 PAY/HR WRK MOR(H-E)"
   V7784 = "C82 COULD WRK LESS(H-E)"
   V7785 = "C83 WANT WRK LESS?(H-E)"
   V7786 = "C84 WANT WRK MORE?(H-E)"
   V7787 = "C85 WANT WRK LESS?(H-E)"
   V7788 = "C86 WANT WRK LESS?(H-E)"
   V7789 = "C87 TIME TO WORK (HD-E)"
   V7790 = "C87 ACC TIME WORK (H-E)"
   V7791 = "C88 # MI TO WORK (HD-E)"
   V7792 = "C89 MODE TRAVL WRK(H-E)"
   V7793 = "C90 GET NEW JOB? (HD-E)"
   V7794 = "C91 WHAT DO-NEW JB(H-E)"
   V7795 = "C92 HD AGE 45-64?(HD-E)"
   V7796 = "C93 AGE PLAN RETR(HD-E)"
   V7797 = "C94 RET BEFORE 65?(H-E)"
   V7798 = "C95 AGE PLAN RETR(HD-E)"
   V7799 = "D1 OCC-JOB SOUGHT(HD-U)"
   V7800 = "D2 PAY/HR JOB SGHT(H-U)"
   V7801 = "D3 WTR NEED TRAING(H-U)"
   V7802 = "D4 WTR LOOKNG JOB(HD-U)"
   V7803 = "D5 # PLAC LOOKED (HD-U)"
   V7804 = "D6 RESERVATN WAGE(HD-U)"
   V7805 = "D7 #WKS LOOK WORK(HD-U)"
   V7806 = "D8 EVER HAD JOB? (HD-U)"
   V7807 = "D9 OCC-LAST JOB  (HD-U)"
   V7808 = "D10 IND-LAST JOB (HD-U)"
   V7809 = "D11 HAPPND LST JOB(H-U)"
   V7810 = "D12 YR LAST WRKD (HD-U)"
   V7811 = "D13 WTR VACATION (HD-U)"
   V7812 = "D14 #WKS VACATION(HD-U)"
   V7813 = "D15 WTR OTRS ILL (HD-U)"
   V7814 = "D16 #WKS OTRS ILL(HD-U)"
   V7815 = "D17 WTR SELF ILL (HD-U)"
   V7816 = "D18 #WKS SELF ILL(HD-U)"
   V7817 = "D19 WTR ON STRIKE(HD-U)"
   V7818 = "D20 #WKS ON STRIKE(H-U)"
   V7819 = "D21 WTR UNEMPLOYD(HD-U)"
   V7820 = "D22 #WKS UNEMPLYD(HD-U)"
   V7821 = "D23 #WKS WORKED  (HD-U)"
   V7822 = "D25 HR/WK WORKED (HD-U)"
   V7823 = "D27 MO/YR LST UNEM(H-U)"
   V7824 = "D28 #WK UNEMP-LST(HD-U)"
   V7825 = "D29 WTR 4+ WK-LST(HD-U)"
   V7826 = "D30 WTR 4+ WK-LST(HD-U)"
   V7827 = "D31 4+ WK> ONCE?1(HD-U)"
   V7828 = "D32 # X NO LOOK-1(HD-U)"
   V7829 = "D34 WTR 2ND UNEMP(HD-U)"
   V7830 = "D35 M0-YR 2ND UNEM(H-U)"
   V7831 = "D36 #WK UNEMP-2ND(HD-U)"
   V7832 = "D37 WTR 4+ WK-2ND(HD-U)"
   V7833 = "D38 WTR 4+ WK-2ND(HD-U)"
   V7834 = "D39 4+ WK> ONCE?2(HD-U)"
   V7835 = "D40 # X NO LOOK-2(HD-U)"
   V7836 = "D41 WTR 3RD UNEMP(HD-U)"
   V7837 = "D42 MO/YR 3RD UNEM(H-U)"
   V7838 = "D43 #WK UNEMP-3RD(HD-U)"
   V7839 = "D44 WTR 4+ WK-3RD(HD-U)"
   V7840 = "D45 WTR 4+ WK-3RD(HD-U)"
   V7841 = "D46 4+ WK> ONCE?3(HD-U)"
   V7842 = "D47 # X NO LOOK-3(HD-U)"
   V7843 = "D48 WTR REC UNEMP(HD-U)"
   V7844 = "D49 WTR USED UP $ $ (HD-U)"
   V7845 = "D50 #WK NO UNEMP$ $ (HD-U)"
   V7846 = "D51 WTR ELIG UNEM(HD-U)"
   V7847 = "D52 WHY NO UNEMP-1(H-U)"
   V7848 = "D52 WHY NO UNEMP-2(H-U)"
   V7849 = "D53 OTR Y/UNEMP? (HD-U)"
   V7850 = "D54 TYPE OTR Y-1 (HD-U)"
   V7851 = "D54 TYPE OTR Y-2 (HD-U)"
   V7852 = "D55 RET SAME EMPLR(H-U)"
   V7853 = "D56 RET SAME JOB?(HD-U)"
   V7854 = "D57 MORE $ $  LATER?(HD-U)"
   V7855 = "D59 TIME TO WORK (HD-U)"
   V7856 = "D59 ACC TIME WORK(HD-U)"
   V7857 = "D60 # MI TO WORK (HD-U)"
   V7858 = "D61 MODE TRAVL WRK(H-U)"
   V7859 = "D62 HD AGE 45-64?(HD-U)"
   V7860 = "D63 AGE PLAN RETR(HD-U)"
   V7861 = "D64 RET BEFORE 65?(H-U)"
   V7862 = "D65 AGE PLAN RETR(HD-U)"
   V7863 = "E1 WTR RETIRED   (HD-R)"
   V7864 = "E2 YEAR RETIRED  (HD-R)"
   V7865 = "E3 WTR WRK FOR $ $  (HD-R)"
   V7866 = "E4 OCCUPATION    (HD-R)"
   V7867 = "E5 INDUSTRY      (HD-R)"
   V7868 = "E6 #WKS WORKED   (HD-R)"
   V7869 = "E7 HR/WK WORKED  (HD-R)"
   V7870 = "E8 WORKING NOW?  (HD-R)"
   V7871 = "E9 HAPPND LST JOB(HD-R)"
   V7872 = "E10 JOB IN FUTURE?(H-R)"
   V7873 = "E11 WHEN GET JOB (HD-R)"
   V7874 = "E12 TYPE JOB SEEK(HD-R)"
   V7875 = "E13 WTR NEED TRNG(HD-R)"
   V7876 = "E14 LOOK FOR JOB?(HD-R)"
   V7877 = "E15 #PLACES LOOKD(HD-R)"
   V7878 = "F1 WIFE IN FU?"
   V7879 = "F2 EMPLOYMENT STAT-WF"
   V7880 = "F3 WORK FOR SELF?(WF-E)"
   V7881 = "F4 WRK FOR GOVT? (WF-E)"
   V7882 = "F5 JOB UNION?    (WF-E)"
   V7883 = "F6 BELONG JOB UN?(WF-E)"
   V7884 = "F7 #MO THIS EMPLR(WF-E)"
   V7885 = "F8-9 OCCUPATION  (WF-E)"
   V7886 = "F10 INDUSTRY     (WF-E)"
   V7887 = "F11 SLRY/HRLY/OTR(WF-E)"
   V7888 = "F12 PAY/HR-SALARY(WF-E)"
   V7889 = "F13 PAY/HR-HOURLY(WF-E)"
   V7890 = "F14 HOW PAID-OTR (WF-E)"
   V7891 = "F15 #MOS THIS JOB(WF-E)"
   V7892 = "F17 MO BEGAN JOB (WF-E)"
   V7893 = "F18 HAPPND PREV JB(W-E)"
   V7894 = "F19 WTR OTRS ILL (WF-E)"
   V7895 = "F20 #WKS OTRS ILL(WF-E)"
   V7896 = "F21 WTR SELF ILL (WF-E)"
   V7897 = "F22 #WKS SELF ILL(WF-E)"
   V7898 = "F23 WTR VACATION (WF-E)"
   V7899 = "F24 #WKS VACATION(WF-E)"
   V7900 = "F25 WTR ON STRIKE(WF-E)"
   V7901 = "F26 #WKS ON STRIK(WF-E)"
   V7902 = "F27 WTR UNEMPLOYD(WF-E)"
   V7903 = "F28 #WKS UNEMPLOYD(W-E)"
   V7904 = "F29 #WKS WORKED  (WF-E)"
   V7905 = "F31 HR/WK WORKED (WF-E)"
   V7906 = "F32 WTR WRKD OT  (WF-E)"
   V7907 = "F34 WTR XTRA JOBS(WF-E)"
   V7908 = "F35 OCC-XTRA JOB (WF-E)"
   V7909 = "F36 #WKS-XTRA JOB(WF-E)"
   V7910 = "F37 HR/WK-XTRA JOB(W-E)"
   V7911 = "F38 TIME TO WORK (WF-E)"
   V7912 = "F38 ACC TIME WORK(WF-E)"
   V7913 = "F39 #MI TO WORK  (WF-E)"
   V7914 = "F40 MODE TRAVL WRK(W-E)"
   V7915 = "G1 OCC-JOB SOUGHT(WF-U)"
   V7916 = "G2 WTR LOOK JOB  (WF-U)"
   V7917 = "G3 #PLACES LOOKED(WF-U)"
   V7918 = "G4 #WKS LOOK WORK(WF-U)"
   V7919 = "G5 EVER HAD JOB? (WF-U)"
   V7920 = "G6 OCC-LAST JOB  (WF-U)"
   V7921 = "G7 IND-LAST JOB  (WF-U)"
   V7922 = "G8 HAPPND LST JOB(WF-U)"
   V7923 = "G9 YEAR LAST WRKD(WF-U)"
   V7924 = "G10 WTR VACATION (WF-U)"
   V7925 = "G11 #WKS VACATION(WF-U)"
   V7926 = "G12 WTR OTRS ILL (WF-U)"
   V7927 = "G13 #WKS OTRS ILL(WF-U)"
   V7928 = "G14 WTR SELF ILL (WF-U)"
   V7929 = "G15 #WKS SELF ILL(WF-U)"
   V7930 = "G16 WTR ON STRIKE(WF-U)"
   V7931 = "G17 #WKS ON STRIK(WF-U)"
   V7932 = "G18 WTR UNEMPLOYD(WF-U)"
   V7933 = "G19 #WKS UNEMPLD (WF-U)"
   V7934 = "G20 #WKS WORKED  (WF-U)"
   V7935 = "G22 HR/WK WORKED (WF-U)"
   V7936 = "G24 TIME TO WORK (WF-U)"
   V7937 = "G24 ACC TIME WORK(WF-U)"
   V7938 = "G25 #MI TO WORK  (WF-U)"
   V7939 = "G26 MODE TRAVL WRK(W-U)"
   V7940 = "H1 WTR RETIRED   (WF-R)"
   V7941 = "H2 YEAR RETIRED  (WF-R)"
   V7942 = "H3 WTR WRK FOR $ $  (WF-R)"
   V7943 = "H4 OCCUPATION    (WF-R)"
   V7944 = "H5 INDUSTRY      (WF-R)"
   V7945 = "H6 # WKS WORKED  (WF-R)"
   V7946 = "H7 HR/WK WORKED  (WF-R)"
   V7947 = "H8 WTR WORK NOW  (WF-R)"
   V7948 = "H9 HAPPND PREV JOB(W-R)"
   V7949 = "H10 JOB IN FUTURE?(W-R)"
   V7950 = "H11 LOOK FOR JOB?(WF-R)"
   V7951 = "H12 #PLACES LOOKED(W-R)"
   V7952 = "J1 MARITAL STATUS"
   V7953 = "J2 WTR EVER MARRIED"
   V7954 = "J3 WHAT HAPND LST MARR"
   V7955 = "J4 WTR WIFE IN FU"
   V7956 = "J5 HR/WK HOUSEWORK - WF"
   V7957 = "J6 HR/WK HOUSEWORK - HD"
   V7958 = "J7 WTR OTRS IN FU"
   V7959 = "J8 WTR OTRS DO HOUSEWORK"
   V7960 = "J26 WTR ELGBL FOOD STAMP"
   V7961 = "J27 WHY NOT ELGBL FD ST1"
   V7962 = "J27 WHY NOT ELGBL FD ST2"
   V7963 = "J28 WTR TRIED REC FD STS"
   V7964 = "J29 WHY CLDNT GET FD STS"
   V7965 = "J30 WHY NOT TRY FD STS 1"
   V7966 = "J30 WHY NOT TRY FD STS 2"
   V7967 = "K1 WTR HEAD FARMER"
   V7968 = "K2 TOT FARM RECEIPTS BKT"
   V7969 = "K5 WHETHER BUSINESS"
   V7970 = "K6 CORP/UNINCORP BUSINES"
   V7971 = "K54 UNION MEMBER?-HD"
   V7972 = "K55 WTR WIFE IN FU"
   V7973 = "K56 UNION MEMBER?-WF"
   V7974 = "K57 WTR PHYS-NERV PROB-H"
   V7975 = "K58 HOW MUCH LIMIT-HD"
   V7976 = "K59 WTR HOSPITALIZED-HD"
   V7977 = "K60 # NIGHTS IN HOSP-HD"
   V7978 = "K61 PAID OWN HOSP BILLS?"
   V7979 = "K62 SICK ABED FOR DAY?-H"
   V7980 = "K63 # DAYS SICK ABED-HD"
   V7981 = "K64 WTR WIFE IN FU"
   V7982 = "K65 WTR PHYS-NERV PROB-W"
   V7983 = "K66 HOW MUCH LIMIT-WF"
   V7984 = "K67 WTR HOSPITALIZED-WF"
   V7985 = "K68 # NIGHTS IN HOSP-WF"
   V7986 = "K69 PAID OWN HOSP BILLS?"
   V7987 = "K70 SICK ABED FOR DAY?-W"
   V7988 = "K71 # DAYS SICK ABED-WF"
   V7989 = "K72 WTR MEDICAID-FAMILY"
   V7990 = "K73 TYPE MEDAID PROGRAM"
   V7991 = "K74 WTR LUMP SUM PAYMNTS"
   V7992 = "K75 BKT LUMP SUM PAYMNTS"
   V7993 = "K76 WTR HELP SUPPORT OTR"
   V7994 = "K77 # OTRS SUPPORTED"
   V7995 = "K79 WTR DEPENDENT OTRS"
   V7996 = "K80 # OTR DEPENDENTS"
   V7997 = "L1 WTR NEW WIFE IN FU"
   V7998 = "L2 EDUCATION-WF"
   V7999 = "L3 WTR OTR SCHOOLING -WF"
   V8000 = "L4 TYPE OTR SCHOOLING-WF"
   V8001 = "L6 WTR BA/BS DEGREE-WF"
   V8002 = "L7 WTR ADVANCED DEG-WF"
   V8003 = "L8 EDUCATION-WFS FA"
   V8004 = "L9 EDUCATION-WFS MO"
   V8005 = "L10 #YRS WRK SINCE 18-WF"
   V8006 = "L11 #YRS WRKD FULLTIME-W"
   V8007 = "L12 P TIME WORKED-WF"
   V8008 = "L12 ACC P TIME WORKED-WF"
   V8009 = "M1 WTR NEW HEAD IN FU"
   V8010 = "M2 STATE GREW UP-HDS FA"
   V8011 = "M2 CNTY GREW UP-HDS FA"
   V8012 = "M2 STATE GREW UP-HDS MO"
   V8013 = "M2 CNTY GREW UP-HDS MO"
   V8014 = "M3 OCCUPATION-HDS FA"
   V8015 = "M4 OCCUPATION-HDS 1ST"
   V8016 = "M5 # DIFF JOBS OR?-HD"
   V8017 = "M6-10 AGE OLDEST KID-HD"
   V8018 = "M6-10 AGE 2ND OLD KID-HD"
   V8019 = "M6-10 AGE 3RD OLD KID-HD"
   V8020 = "M6-10 TOT # CHILDREN-HD"
   V8021 = "M6-10 # KIDS BY 25-HD"
   V8022 = "M11 # SIBLINGS-HD"
   V8023 = "M12 WTR OLDER SIBS-HD"
   V8024 = "M13 GREW UP FARM OR-HD"
   V8025 = "M14-15 STATE GREW UP-HD"
   V8026 = "M14-15 CNTY GREW UP-HD"
   V8027 = "M14-16 #REGIONS LIVED-HD"
   V8028 = "M14-16 #STATES LIVED-HD"
   V8029 = "M17 EVER MOVE FOR JOB?HD"
   V8030 = "M18 NOT MOVED FOR JOB?HD"
   V8031 = "M19 PARENTS POOR OR?-HD"
   V8032 = "M20-21 EDUC-HDS FA"
   V8033 = "M22-23 EDUC-HDS MO"
   V8034 = "M24 WTR VETERAN-HD"
   V8035 = "M25 #YRS WRKD SINCE 18-H"
   V8036 = "M26 #YRS WRKD FULLTIME-H"
   V8037 = "M27 P TIME WORKED-HD"
   V8038 = "M27 ACC P TIME WORKED-HD"
   V8039 = "M28 EDUCATION-HD"
   V8040 = "M29 WTR OTR TRAINING-HD"
   V8041 = "M30 TYPE OTR TRAINING-HD"
   V8042 = "M31 TROUBLE READING?-HD"
   V8043 = "M32 WTR OTR SCHOOLING-HD"
   V8044 = "M33 TYPE OTR SCHOOLING-H"
   V8045 = "M35 WTR BA/BS DEGREE-HD"
   V8046 = "M36 WTR ADVANCED DEG-HD"
   V8047 = "M37 RECORD RELIG PREF?HD"
   V8048 = "M38-39 RELIGIOUS PREF-HD"
   V8049 = "M41 WHO RESPONDENT?"
   V8050 = "M42 # OF INTERVWR CALLS"
   V8051 = "# OF INDIVIDUAL RECORDS"
   V8052 = "H+W 1980 FED TAXES"
   V8053 = "H+W 80 MARGINAL TAX RATE"
   V8054 = "1ST XTRA ERNER 80 TAXES"
   V8055 = "MARG TAX RATE ERNR ONE"
   V8056 = "2ND XTRA ERNER 80 TAXES"
   V8057 = "MARG TAX RATE ERNR TWO"
   V8058 = "3RD XTRA ERNER 80 TAXES"
   V8059 = "MARG TAX RATE ERNR THREE"
   V8060 = "4TH XTRA ERNER 80 TAXES"
   V8061 = "MARG TAX RATE ERNR FOUR"
   V8062 = "5TH XTRA ERNER 80 TAXES"
   V8063 = "MARG TAX RATE ERNR FIVE"
   V8064 = "TOT TAXES ALL XTRA ERNR"
   V8065 = "TOT FAM $ $  Y 80"
   V8066 = "TOT HD LABOR $ $  Y 80"
   V8067 = "1980 $ $  Y/NEEDS"
   V8068 = "ANNUAL FOOD STD"
   V8069 = "HEAD 80 AVG HRLY EARNING"
   V8070 = "WIFE 80 AVG HRLY EARNING"
   V8071 = "REGION 1981 INT"
   V8072 = "REGION 81 HD GREW UP"
   V8073 = "REGION 81 HD FA GREW UP"
   V8074 = "REGION 81 HD MO GREW UP"
   V8075 = "GEOGRAPHIC MOBILITY"
   V8076 = "ACC 80 Y COMPONENTS"
   V8077 = "# MINOR ASSGMTS IN 81"
   V8078 = "# MAJOR ASSGMTS IN 81"
   V8079 = "DU VALUE/ROOM - 1981"
   V8080 = "ACTUL MINUS REQ ROOMS 81"
   V8081 = "PERSON/ROOM IN 1981"
   V8082 = "# 18 OR OLDER IN 81"
   V8083 = "BKT AGE HEAD 1981"
   V8084 = "BKT AGE WIFE 1981"
   V8085 = "EDUCATION 1981 HEAD"
   V8086 = "EDUCATION 1981 WIFE"
   V8087 = "MARITAL STATUS 1981"
   V8088 = "DECILE: 80 TOT FAM $ $  Y"
   V8089 = "DECILE: 80 $ $  Y/NEEDS"
   V8090 = "# CHILDS AGE 1-2"
   V8091 = "# CHILDS AGE 3-5"
   V8092 = "# CHILDS AGE 6-13"
   V8093 = "# FEM CHILDS 14-17"
   V8094 = "# MALE CHILDS 14-17"
   V8095 = "# FEM CHILDS 18-20"
   V8096 = "# MALE CHILDS 18-20"
   V8097 = "# FEM CHILDS 21-29"
   V8098 = "# MALE CHILDS 21-29"
   V8099 = "RACE (FROM 1972)"
   V8100 = "SPLIT SAMPLE FILTER"
   V8101 = "SAMP ERR COMP UNIT(SECU)"
   V8102 = "14YR FAM COMP CHANGE"
   V8103 = "1981 FAMILY WEIGHT"
   V8104 = "UNSKL M CNTY LABOR SUPPL"
   V8105 = "TYPICAL UNSKL WAGE RATE"
   V8106 = "1981 CNTY UNEMP RATE"
   V8107 = "80-81 CNG MARITAL STATUS"
   V8108 = "# 81 S/O FROM THIS FAM"
   V8109 = "81 MAIN FAM ID FOR S/0"
   V8110 = "HOUSEHOLD ID # 81"
   V8111 = "FU PRIMACY WITHIN HU";

* USER-DEFINED MISSING VALUE RECODE TO SAS SYSMIS;

IF V7503=99 THEN V7503=.;
IF V7504=999 THEN V7504=.;
IF V7505=99999 THEN V7505=.;
IF V7506=9 THEN V7506=.;
IF V7508=9 THEN V7508=.;
IF V7509=9 THEN V7509=.;
IF V7529=9999 THEN V7529=.;
IF V7561=9 THEN V7561=.;
IF V7570=99 THEN V7570=.;
IF V7591=99999 THEN V7591=.;
IF V7611=9 THEN V7611=.;
IF V7614=9 THEN V7614=.;
IF V7617=9 THEN V7617=.;
IF V7620=9 THEN V7620=.;
IF V7623=9 THEN V7623=.;
IF V7627=9 THEN V7627=.;
IF V7655=9999 THEN V7655=.;
IF V7656=999 THEN V7656=.;
IF V7658=99 THEN V7658=.;
IF V7660=99 THEN V7660=.;
IF V7662=99 THEN V7662=.;
IF V7663=9 THEN V7663=.;
IF V7664=9 THEN V7664=.;
IF V7665=9 THEN V7665=.;
IF V7666=9 THEN V7666=.;
IF V7667=9 THEN V7667=.;
IF V7668=9 THEN V7668=.;
IF V7669=9 THEN V7669=.;
IF V7670=99999 THEN V7670=.;
IF V7671=9 THEN V7671=.;
IF V7672=9 THEN V7672=.;
IF V7673=9 THEN V7673=.;
IF V7674=9 THEN V7674=.;
IF V7676=9 THEN V7676=.;
IF V7677=99 THEN V7677=.;
IF V7678=9 THEN V7678=.;
IF V7679=9 THEN V7679=.;
IF V7680=9 THEN V7680=.;
IF V7681=9 THEN V7681=.;
IF V7682=9999 THEN V7682=.;
IF V7684=9 THEN V7684=.;
IF V7685=9 THEN V7685=.;
IF V7686=9 THEN V7686=.;
IF V7687=9999 THEN V7687=.;
IF V7689=9 THEN V7689=.;
IF V7690=9999 THEN V7690=.;
IF V7692=9 THEN V7692=.;
IF V7693=9999 THEN V7693=.;
IF V7695=9 THEN V7695=.;
IF V7696=9999 THEN V7696=.;
IF V7698=9 THEN V7698=.;
IF V7699=9999 THEN V7699=.;
IF V7700=9 THEN V7700=.;
IF V7701=99 THEN V7701=.;
IF V7702=9 THEN V7702=.;
IF V7703=9 THEN V7703=.;
IF V7704=9 THEN V7704=.;
IF V7705=9 THEN V7705=.;
IF V7707=9 THEN V7707=.;
IF V7708=9 THEN V7708=.;
IF V7709=9 THEN V7709=.;
IF V7710=9 THEN V7710=.;
IF V7711=999 THEN V7711=.;
IF V7712=999 THEN V7712=.;
IF V7713=999 THEN V7713=.;
IF V7714=9 THEN V7714=.;
IF V7715=9999 THEN V7715=.;
IF V7716=9 THEN V7716=.;
IF V7717=9999 THEN V7717=.;
IF V7718=9999 THEN V7718=.;
IF V7719=9999 THEN V7719=.;
IF V7720=9 THEN V7720=.;
IF V7721=9999 THEN V7721=.;
IF V7722=999 THEN V7722=.;
IF V7723=9 THEN V7723=.;
IF V7724=9 THEN V7724=.;
IF V7725=9 THEN V7725=.;
IF V7726=99 THEN V7726=.;
IF V7727=9 THEN V7727=.;
IF V7728=9 THEN V7728=.;
IF V7729=9 THEN V7729=.;
IF V7730=9 THEN V7730=.;
IF V7731=9 THEN V7731=.;
IF V7732=99 THEN V7732=.;
IF V7733=9 THEN V7733=.;
IF V7734=99 THEN V7734=.;
IF V7735=9 THEN V7735=.;
IF V7736=99 THEN V7736=.;
IF V7737=9 THEN V7737=.;
IF V7738=99 THEN V7738=.;
IF V7739=9 THEN V7739=.;
IF V7740=99 THEN V7740=.;
IF V7741=99 THEN V7741=.;
IF V7742=99 THEN V7742=.;
IF V7743=9 THEN V7743=.;
IF V7744=9 THEN V7744=.;
IF V7745=99 THEN V7745=.;
IF V7746=9 THEN V7746=.;
IF V7747=9999 THEN V7747=.;
IF V7748=99 THEN V7748=.;
IF V7749=99 THEN V7749=.;
IF V7750=9999 THEN V7750=.;
IF V7751=999 THEN V7751=.;
IF V7752=9 THEN V7752=.;
IF V7753=9 THEN V7753=.;
IF V7754=9 THEN V7754=.;
IF V7755=9 THEN V7755=.;
IF V7756=9 THEN V7756=.;
IF V7757=9999 THEN V7757=.;
IF V7758=999 THEN V7758=.;
IF V7759=9 THEN V7759=.;
IF V7760=9 THEN V7760=.;
IF V7761=9 THEN V7761=.;
IF V7762=9 THEN V7762=.;
IF V7763=9 THEN V7763=.;
IF V7764=9999 THEN V7764=.;
IF V7765=999 THEN V7765=.;
IF V7766=9 THEN V7766=.;
IF V7767=9 THEN V7767=.;
IF V7768=9 THEN V7768=.;
IF V7769=9 THEN V7769=.;
IF V7770=9 THEN V7770=.;
IF V7771=9 THEN V7771=.;
IF V7772=99 THEN V7772=.;
IF V7773=9 THEN V7773=.;
IF V7774=99 THEN V7774=.;
IF V7775=99 THEN V7775=.;
IF V7776=9 THEN V7776=.;
IF V7777=99 THEN V7777=.;
IF V7778=99 THEN V7778=.;
IF V7779=9 THEN V7779=.;
IF V7780=9 THEN V7780=.;
IF V7781=9 THEN V7781=.;
IF V7782=9 THEN V7782=.;
IF V7783=9999 THEN V7783=.;
IF V7784=9 THEN V7784=.;
IF V7785=9 THEN V7785=.;
IF V7786=9 THEN V7786=.;
IF V7787=9 THEN V7787=.;
IF V7788=9 THEN V7788=.;
IF V7791=99 THEN V7791=.;
IF V7792=9 THEN V7792=.;
IF V7793=9 THEN V7793=.;
IF V7794=9 THEN V7794=.;
IF V7795=9 THEN V7795=.;
IF V7796=99 THEN V7796=.;
IF V7797=9 THEN V7797=.;
IF V7798=99 THEN V7798=.;
IF V7799=99 THEN V7799=.;
IF V7800=9999 THEN V7800=.;
IF V7801=9 THEN V7801=.;
IF V7802=9 THEN V7802=.;
IF V7803=9 THEN V7803=.;
IF V7804=9999 THEN V7804=.;
IF V7805=99 THEN V7805=.;
IF V7806=9 THEN V7806=.;
IF V7807=999 THEN V7807=.;
IF V7808=999 THEN V7808=.;
IF V7809=9 THEN V7809=.;
IF V7810=99 THEN V7810=.;
IF V7811=9 THEN V7811=.;
IF V7812=99 THEN V7812=.;
IF V7813=9 THEN V7813=.;
IF V7814=99 THEN V7814=.;
IF V7815=9 THEN V7815=.;
IF V7816=99 THEN V7816=.;
IF V7817=9 THEN V7817=.;
IF V7818=99 THEN V7818=.;
IF V7819=9 THEN V7819=.;
IF V7820=99 THEN V7820=.;
IF V7821=99 THEN V7821=.;
IF V7822=99 THEN V7822=.;
IF V7823=9999 THEN V7823=.;
IF V7824=999 THEN V7824=.;
IF V7825=9 THEN V7825=.;
IF V7826=9 THEN V7826=.;
IF V7827=9 THEN V7827=.;
IF V7828=9 THEN V7828=.;
IF V7829=9 THEN V7829=.;
IF V7830=9999 THEN V7830=.;
IF V7831=999 THEN V7831=.;
IF V7832=9 THEN V7832=.;
IF V7833=9 THEN V7833=.;
IF V7834=9 THEN V7834=.;
IF V7835=9 THEN V7835=.;
IF V7836=9 THEN V7836=.;
IF V7837=9999 THEN V7837=.;
IF V7838=999 THEN V7838=.;
IF V7839=9 THEN V7839=.;
IF V7840=9 THEN V7840=.;
IF V7841=9 THEN V7841=.;
IF V7842=9 THEN V7842=.;
IF V7843=9 THEN V7843=.;
IF V7844=9 THEN V7844=.;
IF V7845=99 THEN V7845=.;
IF V7846=9 THEN V7846=.;
IF V7847=99 THEN V7847=.;
IF V7848=99 THEN V7848=.;
IF V7849=9 THEN V7849=.;
IF V7850=99 THEN V7850=.;
IF V7851=99 THEN V7851=.;
IF V7852=9 THEN V7852=.;
IF V7853=9 THEN V7853=.;
IF V7854=9 THEN V7854=.;
IF V7857=99 THEN V7857=.;
IF V7858=9 THEN V7858=.;
IF V7859=9 THEN V7859=.;
IF V7860=99 THEN V7860=.;
IF V7861=9 THEN V7861=.;
IF V7862=99 THEN V7862=.;
IF V7864=99 THEN V7864=.;
IF V7865=9 THEN V7865=.;
IF V7866=999 THEN V7866=.;
IF V7867=999 THEN V7867=.;
IF V7868=99 THEN V7868=.;
IF V7869=99 THEN V7869=.;
IF V7870=9 THEN V7870=.;
IF V7871=9 THEN V7871=.;
IF V7872=9 THEN V7872=.;
IF V7873=99 THEN V7873=.;
IF V7874=9 THEN V7874=.;
IF V7875=9 THEN V7875=.;
IF V7876=9 THEN V7876=.;
IF V7877=9 THEN V7877=.;
IF V7880=9 THEN V7880=.;
IF V7881=9 THEN V7881=.;
IF V7882=9 THEN V7882=.;
IF V7883=9 THEN V7883=.;
IF V7884=999 THEN V7884=.;
IF V7885=999 THEN V7885=.;
IF V7886=999 THEN V7886=.;
IF V7887=9 THEN V7887=.;
IF V7888=9999 THEN V7888=.;
IF V7889=9999 THEN V7889=.;
IF V7890=9 THEN V7890=.;
IF V7891=999 THEN V7891=.;
IF V7892=99 THEN V7892=.;
IF V7893=9 THEN V7893=.;
IF V7894=9 THEN V7894=.;
IF V7895=99 THEN V7895=.;
IF V7896=9 THEN V7896=.;
IF V7897=99 THEN V7897=.;
IF V7898=9 THEN V7898=.;
IF V7899=99 THEN V7899=.;
IF V7900=9 THEN V7900=.;
IF V7901=99 THEN V7901=.;
IF V7902=9 THEN V7902=.;
IF V7903=99 THEN V7903=.;
IF V7904=99 THEN V7904=.;
IF V7905=99 THEN V7905=.;
IF V7906=9 THEN V7906=.;
IF V7907=9 THEN V7907=.;
IF V7908=99 THEN V7908=.;
IF V7909=99 THEN V7909=.;
IF V7910=99 THEN V7910=.;
IF V7913=99 THEN V7913=.;
IF V7914=9 THEN V7914=.;
IF V7915=99 THEN V7915=.;
IF V7916=9 THEN V7916=.;
IF V7917=9 THEN V7917=.;
IF V7918=99 THEN V7918=.;
IF V7919=9 THEN V7919=.;
IF V7920=999 THEN V7920=.;
IF V7921=999 THEN V7921=.;
IF V7922=9 THEN V7922=.;
IF V7923=99 THEN V7923=.;
IF V7924=9 THEN V7924=.;
IF V7925=99 THEN V7925=.;
IF V7926=9 THEN V7926=.;
IF V7927=99 THEN V7927=.;
IF V7928=9 THEN V7928=.;
IF V7929=99 THEN V7929=.;
IF V7930=9 THEN V7930=.;
IF V7931=99 THEN V7931=.;
IF V7932=9 THEN V7932=.;
IF V7933=99 THEN V7933=.;
IF V7934=99 THEN V7934=.;
IF V7935=99 THEN V7935=.;
IF V7938=99 THEN V7938=.;
IF V7939=9 THEN V7939=.;
IF V7941=99 THEN V7941=.;
IF V7942=9 THEN V7942=.;
IF V7943=999 THEN V7943=.;
IF V7944=999 THEN V7944=.;
IF V7945=99 THEN V7945=.;
IF V7946=99 THEN V7946=.;
IF V7947=9 THEN V7947=.;
IF V7948=9 THEN V7948=.;
IF V7949=9 THEN V7949=.;
IF V7950=9 THEN V7950=.;
IF V7951=9 THEN V7951=.;
IF V7952=9 THEN V7952=.;
IF V7953=9 THEN V7953=.;
IF V7954=9 THEN V7954=.;
IF V7956=99 THEN V7956=.;
IF V7957=99 THEN V7957=.;
IF V7959=9 THEN V7959=.;
IF V7960=9 THEN V7960=.;
IF V7961=9 THEN V7961=.;
IF V7962=9 THEN V7962=.;
IF V7963=9 THEN V7963=.;
IF V7964=9 THEN V7964=.;
IF V7965=9 THEN V7965=.;
IF V7966=9 THEN V7966=.;
IF V7967=9 THEN V7967=.;
IF V7968=9 THEN V7968=.;
IF V7969=9 THEN V7969=.;
IF V7970=9 THEN V7970=.;
IF V7971=9 THEN V7971=.;
IF V7973=9 THEN V7973=.;
IF V7974=9 THEN V7974=.;
IF V7975=9 THEN V7975=.;
IF V7976=9 THEN V7976=.;
IF V7977=999 THEN V7977=.;
IF V7978=9 THEN V7978=.;
IF V7979=9 THEN V7979=.;
IF V7980=999 THEN V7980=.;
IF V7982=9 THEN V7982=.;
IF V7983=9 THEN V7983=.;
IF V7984=9 THEN V7984=.;
IF V7985=999 THEN V7985=.;
IF V7986=9 THEN V7986=.;
IF V7987=9 THEN V7987=.;
IF V7988=999 THEN V7988=.;
IF V7989=9 THEN V7989=.;
IF V7990=9 THEN V7990=.;
IF V7991=9 THEN V7991=.;
IF V7992=9 THEN V7992=.;
IF V7993=9 THEN V7993=.;
IF V7994=9 THEN V7994=.;
IF V7995=9 THEN V7995=.;
IF V7996=9 THEN V7996=.;
IF V7998=99 THEN V7998=.;
IF V7999=9 THEN V7999=.;
IF V8000=9 THEN V8000=.;
IF V8001=9 THEN V8001=.;
IF V8002=9 THEN V8002=.;
IF V8003=9 THEN V8003=.;
IF V8004=9 THEN V8004=.;
IF V8005=99 THEN V8005=.;
IF V8006=99 THEN V8006=.;
IF V8010=99 THEN V8010=.;
IF V8011=999 THEN V8011=.;
IF V8012=99 THEN V8012=.;
IF V8013=999 THEN V8013=.;
IF V8014=9 THEN V8014=.;
IF V8015=9 THEN V8015=.;
IF V8016=9 THEN V8016=.;
IF V8017=99 THEN V8017=.;
IF V8018=99 THEN V8018=.;
IF V8019=99 THEN V8019=.;
IF V8020=99 THEN V8020=.;
IF V8021=9 THEN V8021=.;
IF V8022=9 THEN V8022=.;
IF V8023=9 THEN V8023=.;
IF V8024=9 THEN V8024=.;
IF V8025=99 THEN V8025=.;
IF V8026=999 THEN V8026=.;
IF V8027=9 THEN V8027=.;
IF V8028=9 THEN V8028=.;
IF V8029=9 THEN V8029=.;
IF V8030=9 THEN V8030=.;
IF V8031=9 THEN V8031=.;
IF V8032=9 THEN V8032=.;
IF V8033=9 THEN V8033=.;
IF V8034=9 THEN V8034=.;
IF V8035=99 THEN V8035=.;
IF V8036=99 THEN V8036=.;
IF V8039=99 THEN V8039=.;
IF V8040=9 THEN V8040=.;
IF V8041=9 THEN V8041=.;
IF V8042=9 THEN V8042=.;
IF V8043=9 THEN V8043=.;
IF V8044=9 THEN V8044=.;
IF V8045=9 THEN V8045=.;
IF V8046=9 THEN V8046=.;
IF V8047=9 THEN V8047=.;
IF V8048=9 THEN V8048=.;
IF V8049=9 THEN V8049=.;
IF V8050=9 THEN V8050=.;
IF V8071=9 THEN V8071=.;
IF V8072=9 THEN V8072=.;
IF V8073=9 THEN V8073=.;
IF V8074=9 THEN V8074=.;
IF V8075=9 THEN V8075=.;
IF V8079=99999 THEN V8079=.;
IF V8080=9 THEN V8080=.;
IF V8081=9.9 THEN V8081=.;
IF V8083=9 THEN V8083=.;
IF V8084=9 THEN V8084=.;
IF V8085=9 THEN V8085=.;
IF V8086=9 THEN V8086=.;
IF V8099=9 THEN V8099=.;
IF V8104=9 THEN V8104=.;
IF V8105=9999 THEN V8105=.;
IF V8106=99 THEN V8106=.;
 
file rawdat lrecl=1241;
put    
v7502
v7510
v7517
v7518
v7519
v7525
v7526
v7530
v7531
v7532
v7534
v7540
v7541
v7542
v7544
v7554
v7562
v7563
v7564
v7565
v7566
v7567
v7568
v7569
v7579
v7580
v7581
v7586
v7588
v7590
v7608
v7624
v7625
v7627
v7638
v7655
v7657
v7658
v7659
v7660
v7669
v7675
v7676
v7677
v7678
v7699
v7700
v7701
v7702
v7706
v7707
v7711
v7727
v7741
v7742
v7805
v7809
v7821
v7822
v7879
v7880
v7884
v7893
v7904
v7905
v7918
v7922
v7934
v7935
v7947
v7974
v7992
v7994
v7998
v8001
v8009
v8039
v8045
v8052
v8053
v8064
v8065
v8066
v8071
v8076
v8085
v8086
v8087
v8099
v8103
v30357
;

 proc means;
 run; 
